# Внешний редактор
Во время игры встроенного текстового редактора обычно хватает, но он, само собой, не может конкурировать с более сложными текстовыми редакторами типа Visual Studio Code (VS Code).

Игра сохраняет все файлы с кодом в формате .py, поэтому ты можешь редактировать их в редакторах Python.
Обрати внимание, что этот вариант добавлен только для удобства. На самом деле в игре используется не Python, но язык достаточно близок к нему, чтобы на нем　выполнялся Python IntelliSense.
Ты можешь найти файлы в [папке сохранений](persistent_data_path/Saves).

Для работы IntelliSense каждое сохранение также содержит файл `__builtins__.py` со встроенными определениями Python, соответствующими встроенным функциям игры.
VS Code автоматически обнаруживает `__builtins__.py`, но в некоторых редакторах для работы необходимо добавить `from __builtins__ import *`.

Чтобы видеть в игре внешние изменения без перезагрузки сохранения, нужно включить отслеживание файлов в настройках. Если ты создашь или удалишь файлы извне, то все равно придется перезагрузить сохранение, чтобы увидеть изменения.

## Использование VS Code
Visual Studio Code — рекомендуемый редактор кода для использования в игре The Farmer Was Replaced.

Его можно установить [здесь](https://code.visualstudio.com/download).

После загрузки установи в VS Code расширение Python.

Затем открой [папку](persistent_data_path/Saves) с твоими файлами `.py` в VS Code. Необходимо открыть именно всю папку, а не отдельные файлы, иначе не будет учтен файл `__builtins__.py`.

В игре необходимо включить настройку «Отслеживание файлов». Теперь каждый раз, когда ты сохраняешь код в VS Code, изменения будут автоматически отображаться в игре.

Вот и все! Теперь ты можешь писать код в профессиональном редакторе.